/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef SPICE3_HEADCORRECTION_API_
#define SPICE3_HEADCORRECTION_API_

#include "rlTypes.h"

RL_C_API rlResult rlHeadCorrectionExists(rlHandle handle, int32_t head, int32_t correction, bool* outExists);
RL_C_API rlResult rlHeadCorrectionDelete(rlHandle handle, int32_t head, int32_t correction);
RL_C_API rlResult rlHeadCorrectionGet(rlHandle handle, int32_t head, int32_t correction, const char* localFileName);
RL_C_API rlResult rlHeadCorrectionSet(rlHandle handle, int32_t head, int32_t correction, const char* localFileName);

RL_C_API rlResult rlHeadCorrectionLoad(rlHandle handle);
RL_C_API rlResult rlHeadCorrectionStore(rlHandle handle);

RL_C_API rlResult rlHeadCorrectionInitOpticalParameters(rlOpticalParameters* parameters);
RL_C_API rlResult rlHeadCorrectionGetOpticalParameters(rlHandle handle, int32_t head, int32_t correction, rlOpticalParameters* parameters);
RL_C_API rlResult rlHeadCorrectionGetHash(rlHandle handle, int32_t head, int32_t correction, char* outBuffer, uint32_t bufferLen, uint32_t* outLen);

RL_C_API rlResult rlHeadCorrectionSelectCorrection(rlHandle handle, int32_t head, int32_t correction);
RL_C_API rlResult rlHeadCorrectionGetSelectedCorrection(rlHandle handle, int32_t head, int32_t* outSelectedCorrection);

#endif // SPICE3_HEADCORRECTION_API_
